///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains all ZCB format-related constants.
 *	\file		IceZCBFormat.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEZCBFORMAT_H__
#define __ICEZCBFORMAT_H__

	// Chunk versions
	#define	CHUNK_MAIN_VER			2
	#define	CHUNK_MESH_VER			5
	#define	CHUNK_CAMS_VER			1
	#define	CHUNK_LITE_VER			3
	#define	CHUNK_SHAP_VER			2
	#define	CHUNK_HELP_VER			2
	#define	CHUNK_TEXM_VER			2
	#define	CHUNK_MATL_VER			2
	#define	CHUNK_CTRL_VER			2
	#define	CHUNK_MOVE_VER			3

	// Mesh flags.
	#define	ZCB_VFACE				(1<<0)				//!< Mesh has vertex-faces.
	#define	ZCB_TFACE				(1<<1)				//!< Mesh has texture-faces.
	#define	ZCB_CFACE				(1<<2)				//!< Mesh has color-faces.
	#define ZCB_UVW					(1<<3)				//!< UVW's are exported
	#define ZCB_WDISCARDED			(1<<4)				//!< W is discarded
	#define ZCB_VERTEXCOLORS		(1<<5)				//!< Vertex colors are exported
	#define	ZCB_ONEBONEPERVERTEX	(1<<6)				//!< Simple skin with one driving bone/vertex
	#define	ZCB_CONVEXHULL			(1<<7)				//!< The convex hull has been exported
	#define	ZCB_BOUNDINGSPHERE		(1<<8)				//!< The bounding sphere has been exported
	#define	ZCB_INERTIATENSOR		(1<<9)				//!< The inertia tensor has been exported
	#define	ZCB_QUANTIZEDVERTICES	(1<<10)				//!< Vertices have been quantized
	#define	ZCB_WORDFACES			(1<<11)				//!< Vertex references within faces are stored as words instead of dwords
	#define	ZCB_COMPRESSED			(1<<12)				//!< Mesh has been saved in a compression-friendly way
	#define	ZCB_EDGEVIS				(1<<13)				//!< Edge visibility has been exported

	#define	ZCB_CONSOLIDATION		(1<<16)				//!< Mesh has been consolidated
	#define	ZCB_FACENORMALS			(1<<17)				//!< Export normals to faces
	#define	ZCB_VERTEXNORMALS		(1<<18)				//!< Export normals to vertices
	#define	ZCB_NORMALINFO			(1<<19)				//!< Export NormalInfo

	// Scene flags
	enum ZCBFile
	{
		ZCB_FILE_SCENE				= 0x00001000,		//!< Complete 3D scene
		ZCB_FILE_MOTION				= 0x00001100,		//!< Motion file
		ZCB_FILE_FORCE_DWORD		= 0x7fffffff
	};

	// Object types
	enum ZCBObjType
	{
		ZCB_OBJ_UNDEFINED			= 0,				//!< Undefined object
		ZCB_OBJ_CAMERA				= 1,				//!< A camera
		ZCB_OBJ_LIGHT				= 2,				//!< A light
		ZCB_OBJ_MESH				= 3,				//!< A mesh
		ZCB_OBJ_BPATCH				= 4,				//!< A b-patch
		ZCB_OBJ_CONTROLLER			= 5,				//!< A controller
		ZCB_OBJ_HELPER				= 6,				//!< A helper
		ZCB_OBJ_MATERIAL			= 7,				//!< A material
		ZCB_OBJ_TEXTURE				= 8,				//!< A texture
		ZCB_OBJ_MOTION				= 9,				//!< A character motion
		ZCB_OBJ_SHAPE				= 10,				//!< A shape
		ZCB_OBJ_FORCE_DWORD			= 0x7fffffff
	};

	// Controllers flags
	enum ZCBCtrlType
	{
		ZCB_CTRL_NONE				= 0,				//!< No controller
		ZCB_CTRL_FLOAT				= 1,				//!< Float controller
		ZCB_CTRL_VECTOR				= 2,				//!< Vector controller
		ZCB_CTRL_QUAT				= 3,				//!< Quaternion controller
		ZCB_CTRL_PR					= 4,				//!< PR controller
		ZCB_CTRL_PRS				= 5,				//!< PRS controller
		ZCB_CTRL_VERTEXCLOUD		= 6,				//!< Morph controller
		ZCB_CTYPE_FORCE_DWORD		= 0x7fffffff
	};

	enum ZCBCtrlMode
	{
		ZCB_CTRL_SAMPLES			= 1,				//!< Samples
		ZCB_CTRL_KEYFRAMES			= 2,				//!< Keyframes
		ZCB_CTRL_PROCEDURAL			= 3,				//!< Procedural
		ZCB_CMODE_FORCE_DWORD		= 0x7fffffff
	};

	// Compression flags
	enum ZCBCompression
	{
		ZCB_COMPRESSION_NONE		= 0,				//!< Not compressed
		ZCB_COMPRESSION_ZLIB		= 1,				//!< Compressed with ZLib
		ZCB_COMPRESSION_BZIP2		= 2,				//!< Compressed with BZip2	
		ZCB_COMPRESSION_CUSTOM		= 3,				//!< Custom compression
		ZCB_COMPRESSION_FORCE_DWORD	= 0x7fffffff
	};

#endif // __ICEZCBFORMAT_H__
